<?php declare(strict_types=1);

/**
 * This file is part of the Nette Framework (https://nette.org)
 * Copyright (c) 2004 David Grudl (https://davidgrudl.com)
 */

namespace Nette\Routing;

use Nette;


/**
 * The bi-directional router.
 */
interface Router
{
	/** for back compatibility */
	public const ONE_WAY = 0b0001;

	/**
	 * Maps HTTP request to an array.
	 * @return ?array<string, mixed>
	 */
	function match(Nette\Http\IRequest $httpRequest): ?array;

	/**
	 * Constructs absolute URL from array.
	 * @param array<string, mixed>  $params
	 */
	function constructUrl(array $params, Nette\Http\UrlScript $refUrl): ?string;
}
