<?php

declare(strict_types=1);

namespace App\UI\Sign;

use Nette;

class SignPresenter extends Nette\Application\UI\Presenter
{
	public function actionIn(): void
	{
		if ($this->getUser()->isLoggedIn()) {
			$this->redirect('Admin:default');
		}

		$post = $this->getHttpRequest()->getPost();

		if (!empty($post['username']) && !empty($post['password'])) {
			try {
				$this->getUser()->login($post['username'], $post['password']);
				$this->redirect('Admin:default');
			} catch (Nette\Security\AuthenticationException $e) {
				$this->flashMessage('Nesprávné přihlašovací údaje.', 'error');
				$this->redirect('this');
			}
		}
	}

	public function actionOut(): void
	{
		$this->getUser()->logout();
		$this->flashMessage('Byli jste odhlášeni.');
		$this->redirect('Sign:in');
	}
}
