<?php

declare(strict_types=1);

namespace App\Model;

use Nette;

class ServiceCategoryRepository
{
	public function __construct(
		private Nette\Database\Explorer $database,
	) {
	}

	public function findAll(): Nette\Database\Table\Selection
	{
		return $this->database->table('service_categories')->order('weight ASC');
	}

	public function findActive(): Nette\Database\Table\Selection
	{
		return $this->findAll()->where('active', 1);
	}

	public function findById(int $id): ?Nette\Database\Table\ActiveRow
	{
		return $this->findAll()->get($id) ?: null;
	}

	public function insert(array $values): Nette\Database\Table\ActiveRow
	{
		return $this->database->table('service_categories')->insert($values);
	}

	public function update(int $id, array $values): void
	{
		$this->database->table('service_categories')->where('id', $id)->update($values);
	}

	public function delete(int $id): void
	{
		$this->database->table('service_categories')->where('id', $id)->delete();
	}
}
