<?php

declare(strict_types=1);

namespace App\Model;

use Nette;

class EmailRepository
{
	public function __construct(
		private Nette\Database\Explorer $database,
	) {
	}

	public function findAll(): Nette\Database\Table\Selection
	{
		return $this->database->table('emails');
	}

	public function findById(int $id): ?Nette\Database\Table\ActiveRow
	{
		return $this->findAll()->get($id) ?: null;
	}

	public function insert(iterable $values): void
	{
		$this->findAll()->insert($values);
	}

	public function findByEmail(string $email): ?Nette\Database\Table\ActiveRow
	{
		return $this->findAll()->where('email', $email)->fetch() ?: null;
	}

	public function findByToken(string $token): ?Nette\Database\Table\ActiveRow
	{
		return $this->findAll()->where('token', $token)->fetch() ?: null;
	}
}
