<?php

declare(strict_types=1);

namespace App\Model;

use Nette;

class BookingRepository
{
	public function __construct(
		private Nette\Database\Explorer $database,
	) {
	}

	public function findAll(): Nette\Database\Table\Selection
	{
		return $this->database->table('bookings')->order('created_at DESC');
	}

	public function findById(int $id): ?Nette\Database\Table\ActiveRow
	{
		return $this->database->table('bookings')->get($id) ?: null;
	}

	public function insert(array $values): Nette\Database\Table\ActiveRow
	{
		return $this->database->table('bookings')->insert($values);
	}

	public function updateStatus(int $id, string $status): void
	{
		$this->database->table('bookings')
			->where('id', $id)
			->update(['status' => $status]);
	}

	public function countNew(): int
	{
		return $this->database->table('bookings')
			->where('status', 'new')
			->count('*');
	}
}
