<?php

declare(strict_types=1);

namespace App\Model;

use Nette;

class AuditLogRepository
{
	public function __construct(
		private Nette\Database\Explorer $database,
	) {
	}

	public function log(string $action, ?string $ip, ?string $userAgent, ?string $data = null, ?string $detail = null): void
	{
		$this->database->table('audit_log')->insert([
			'action' => $action,
			'ip' => $ip,
			'user_agent' => $userAgent,
			'data' => $data,
			'detail' => $detail,
		]);
	}

	public function findAll(): Nette\Database\Table\Selection
	{
		return $this->database->table('audit_log')->order('created_at DESC');
	}
}
