<?php

declare(strict_types=1);

namespace App\Core;

use Nette;
use Nette\Application\Routers\RouteList;
use Nette\Routing\Router;

final class RouterFactory
{
	use Nette\StaticClass;

	public static function createRouter(): Router
	{
		$router = new RouteList;

		// Admin routes (no locale prefix)
		$router->addRoute('admin/<action>[/<id>]', [
			'presenter' => 'Admin',
			'action' => 'default',
		]);

		// Sign routes (no locale prefix)
		$router->addRoute('sign/<action>', [
			'presenter' => 'Sign',
			'action' => 'in',
		]);

		// Unsubscribe route
		$router->addRoute('odhlasit/<token>', [
			'presenter' => 'Homepage',
			'action' => 'unsubscribe',
		]);

		// Localized homepage — /uk/ or /en/
		$router->addRoute('<locale cs|en|de|pl|sl|ua>/', [
			'presenter' => 'Homepage',
			'action' => 'default',
			'locale' => 'cs',
		]);

		// Homepage root (default cs)
		$router->addRoute('', [
			'presenter' => 'Homepage',
			'action' => 'default',
		]);


		// Catch-all → homepage
		$router->addRoute('<path .+>', [
			'presenter' => 'Homepage',
			'action' => 'default',
		]);

		return $router;
	}
}
