<?php

declare(strict_types=1);

namespace App;

use Nette\Bootstrap\Configurator;

class Bootstrap
{
	public static function boot(): Configurator
	{
		date_default_timezone_set('Europe/Prague');

		$configurator = new Configurator;
		$appDir = dirname(__DIR__);

		$configurator->setDebugMode(php_sapi_name() === 'cli' || in_array($_SERVER['REMOTE_ADDR'] ?? '', ['127.0.0.1', '::1'], true));
		$configurator->enableTracy($appDir . '/log');
		$configurator->setTempDirectory($appDir . '/temp');
		$configurator->addConfig($appDir . '/config/common.neon');

		return $configurator;
	}
}
